<?php
/**
 * Default phpIPAM.png logo
 */
if ($logo_width <= 220) {
    // Email Optimised [resized,pngcrush] 220x54, 2.2Kb
    $img = "<img style='max-width:".$logo_width."px;margin-top:15px;margin-bottom:20px;' alt='phpipam' src='data:image/png;base64,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'>";
} else {
    // Original Optimised [pngcrush] 650x150, 33Kb
    $img = "<img style='max-width:".$logo_width."px;margin-top:15px;margin-bottom:20px;' alt='phpipam' src='data:image/png;base64,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'>";
}
